package com.vmware.samples.chassisui {
import com.vmware.core.model.IResourceReference;
import com.vmware.flexutil.proxies.BaseProxy;
import com.vmware.flexutil.ServiceUtil;
import com.vmware.samples.chassisui.model.ChassisInfo;

/**
 * Proxy class for the java ChassisService.
 */
public class ChassisServiceProxy extends BaseProxy
{
   // This service name must match the flex:remoting-destination in bundle-context.xml
   private static const SERVICE_NAME:String = "chassisService";

   /**
    * Create an ChassisServiceProxy with a secure channel.
    */
   public function ChassisServiceProxy() {
      // channelUri uses the Web-ContextPath defined in MANIFEST.MF
      const channelUri:String = ServiceUtil.getDefaultChannelUri(Chassisui.contextPath);
      super(SERVICE_NAME, channelUri);
   }

   /**
    * Deletes the chassis.
    *
    * @param chassisObject  The Chassis to be deleted.
    * @param callBack       Optional callback method
    * @param callContext    Optional object that is passed back in the callback method
    */
   public function deleteChassis(
         chassisObject:IResourceReference,
         callback:Function = null,
         context:Object = null):void {
      callService("deleteChassis", [chassisObject], callback, context);
   }

   /**
    * Edits the chassis.
    *
    * @param chassisObject  The edited Chassis
    * @param callBack       Optional callback method
    * @param callContext    Optional object that is passed back in the callback method
    */
   public function editChassis(
         chassisObject:IResourceReference,
         callback:Function = null,
         context:Object = null):void {
      callService("editChassis", [chassisObject], callback, context);
   }

   /**
    * Creates a new chassis.
    *
    * @param chassisInfo    The data to create a new chassis.
    * @param callBack       Optional callback method
    * @param callContext    Optional object that is passed back in the callback method
    */
   public function createChassis(
         chassisInfo:ChassisInfo,
         callback:Function = null,
         context:Object = null):void {
      callService("createChassis", [chassisInfo], callback, context);
   }
}
}

